<?php
// =====================================================
// ADMIN – Création d'un nouvel engin
// =====================================================
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// --- Sécurité : accès réservé ---
if (!isset($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header('Location: admin-login.php');
    exit;
}

// -----------------------------------------------------
// Paramètres de base
// -----------------------------------------------------
$client = isset($_GET['client']) ? $_GET['client'] : 'ECF_VIGIER';

$dataRoot        = "/var/www/docnlink/data";
$clientEnginsDir = $dataRoot . "/clients/$client/engins";
$clientPhotosDir = $dataRoot . "/photos/$client";
$clientDocsDir   = $dataRoot . "/documents/$client";

// Création des dossiers racine si besoin
@mkdir($clientEnginsDir, 0775, true);
@mkdir($clientPhotosDir, 0775, true);
@mkdir($clientDocsDir,   0775, true);

$message  = "";
$isError  = false;
$newId    = "";

// -----------------------------------------------------
// TRAITEMENT DU FORMULAIRE
// -----------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $id          = trim($_POST['id'] ?? '');
    $marque      = trim($_POST['marque'] ?? '');
    $type        = trim($_POST['type'] ?? '');
    $numeroSerie = trim($_POST['numero_serie'] ?? '');
    $immat       = trim($_POST['immat'] ?? '');
    $annee       = trim($_POST['annee'] ?? '');
    $poids       = trim($_POST['poids'] ?? '');
    $dateVgp     = trim($_POST['date_vgp'] ?? '');
    $dateAss     = trim($_POST['date_assurance'] ?? '');

    // Validation minimale
    if ($id === '' || $marque === '') {
        $isError = true;
        $message = "⚠ L'identifiant et la marque de l'engin sont obligatoires.";
    } else {
        $newId = $id;

        // Dossiers spécifiques à l'engin
        $enginJsonPath   = $clientEnginsDir . "/$id.json";
        $enginPhotoDir   = $clientPhotosDir . "/$id";
        $enginDocsDir    = $clientDocsDir . "/$id";

        @mkdir($enginPhotoDir, 0775, true);
        @mkdir($enginDocsDir, 0775, true);

        // -------------------------------------------------
        // Gestion de la photo
        // -------------------------------------------------
        $photoUrl = "";
        if (!empty($_FILES['photo']['name']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {

            // Utiliser le vrai nom nettoyé
            $ext = strtolower(pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION));
            $photoName = preg_replace('/[^a-zA-Z0-9._-]/', '_', $_FILES['photo']['name']);
            $destPhotoPath = $enginPhotoDir . "/" . $photoName;

            // Effacer anciennes photos
            foreach (glob($enginPhotoDir . "/*.{jpg,jpeg,png}", GLOB_BRACE) as $old) {
                unlink($old);
            }

            if (!move_uploaded_file($_FILES['photo']['tmp_name'], $destPhotoPath)) {
                $isError = true;
                $message = "Erreur lors de l'upload de la photo.";
            } else {
                $photoUrl = "https://docnlink.fr/data/photos/$client/" . rawurlencode($id) . "/" . rawurlencode($photoName);
            }
        }

        // -------------------------------------------------
        // Construction du JSON engin
        // -------------------------------------------------
        if (!$isError) {
            $jsonData = [
                "logo"         => "https://docnlink.fr/logos/vigier.png",
                "marque"       => $marque,
                "type"         => $type,
                "numero_serie" => $numeroSerie,
                "immat"        => $immat !== "" ? $immat : $id,
                "annee"        => $annee,
                "poids"        => $poids,
                "photo"        => $photoUrl,
                "validite"     => [
                    "vgp"        => $dateVgp,
                    "assurance"  => $dateAss,
                ],
            ];

            if (file_put_contents(
                $enginJsonPath,
                json_encode($jsonData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)
            ) === false) {
                $isError = true;
                $message = "Erreur lors de l'enregistrement du fichier JSON.";
            } else {
                $message = "✔ Engin créé avec succès.";
            }
        }
    }
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Admin – Créer un engin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { margin:0; padding:0; font-family:Arial, sans-serif; background:#f3f3f3; }
        .header {
            background:#00428B; color:#fff; padding:10px 15px;
            display:flex; justify-content:space-between; align-items:center;
        }
        .header a { color:#fff; text-decoration:none; margin-left:15px; font-size:14px; }
        .container { max-width:900px; margin:20px auto; padding:0 10px; }
        .card {
            background:#fff; border-radius:8px;
            box-shadow:0 2px 6px rgba(0,0,0,0.15);
            padding:15px; margin-bottom:15px;
        }
        h1 { margin:0 0 10px 0; font-size:22px; }
        label { display:block; font-weight:bold; margin-top:10px; font-size:14px; }
        input[type="text"], input[type="date"], input[type="number"], input[type="file"] {
            width:100%; padding:8px; margin-top:3px; border-radius:4px;
            border:1px solid #ccc; box-sizing:border-box; font-size:14px;
        }
        .btn-primary {
            display:inline-block; background:#00428B; color:#fff; border:none;
            padding:10px 18px; border-radius:6px; font-size:15px;
            margin-top:15px; cursor:pointer; text-decoration:none;
        }
        .btn-secondary {
            display:inline-block; background:#777; color:#fff; border:none;
            padding:8px 14px; border-radius:6px; font-size:14px;
            margin-top:10px; cursor:pointer; text-decoration:none;
        }
        .msg-ok { color:green; margin-bottom:10px; font-weight:bold; }
        .msg-error { color:red; margin-bottom:10px; font-weight:bold; }
    </style>
</head>
<body>

<div class="header">
    <div><strong>DocNLinK – Admin</strong> (<?php echo htmlspecialchars($client); ?>)</div>
    <div>
        <a href="admin-panel.php">⬅ Panneau admin</a>
        <a href="admin-logout.php">🔒 Déconnexion</a>
    </div>
</div>

<div class="container">
    <div class="card">
        <h1>Créer un nouvel engin</h1>

        <?php if ($message): ?>
            <div class="<?php echo $isError ? 'msg-error' : 'msg-ok'; ?>">
                <?php echo htmlspecialchars($message); ?>
                <?php if (!$isError && $newId): ?>
                    <br>
                    <a class="btn-secondary"
                       href="fiche-engin.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($newId); ?>">
                        👉 Voir la fiche créée
                    </a>
                    <a class="btn-secondary"
                       href="admin-documents.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($newId); ?>">
                        ⚙️ Gérer ses documents
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data">
            <label>Identifiant / Numéro de parc *</label>
            <input type="text" name="id" placeholder="CE-31, 002…" required>

            <label>Marque de l'engin *</label>
            <input type="text" name="marque" placeholder="Toyota, Manitou, Fenwick…" required>

            <label>Type</label>
            <input type="text" name="type" placeholder="R489 Cat 3">

            <label>Numéro de série</label>
            <input type="text" name="numero_serie" placeholder="ABC123456">

            <label>Immatriculation / Parc</label>
            <input type="text" name="immat" placeholder="CE-31…">

            <label>Année</label>
            <input type="text" name="annee" placeholder="2021">

            <label>Poids</label>
            <input type="text" name="poids" placeholder="3200 kg">

            <label>Date VGP</label>
            <input type="date" name="date_vgp">

            <label>Date Assurance</label>
            <input type="date" name="date_assurance">

            <label>Photo de l'engin</label>
            <input type="file" name="photo" accept="image/*">

            <button type="submit" class="btn-primary">Créer l'engin</button>
        </form>
    </div>
</div>

</body>
</html>

