<?php
session_start();

if (!isset($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header('Location: admin-login.php');
    exit;
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

// ==========================
// PARAMÈTRES
// ==========================
$client = "ECF_VIGIER";
$basePath = "/var/www/docnlink/data/clients/$client/engins";

$engins = [];
foreach (glob($basePath . "/*.json") as $file) {

    $id = basename($file, ".json");
    $json = json_decode(file_get_contents($file), true);

    if (!$json) continue;

    $assurance = $json["validite"]["assurance"] ?? "";
    $vgp       = $json["validite"]["vgp"] ?? "";
    $immat     = $json["immat"] ?? $id;
    $nom       = $json["nom"] ?? $id;

    $engins[] = [
        "id"        => $id,
        "immat"     => $immat,
        "nom"       => $nom,
        "assurance" => $assurance,
        "vgp"       => $vgp
    ];
}

// ==========================
// FONCTION BADGE
// ==========================
function badge($date)
{
    if (!$date) return "<span style='color:#555;'>—</span>";

    $ts = strtotime($date);
    $today = strtotime("today");

    if ($ts < $today)
        return "<span style='color:red;font-weight:bold;'>EXPIRÉ ($date)</span>";

    $diff = ($ts - $today) / 86400;

    if ($diff < 15)
        return "<span style='color:orange;font-weight:bold;'>Bientôt ($date)</span>";

    return "<span style='color:green;'>$date</span>";
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Résumé Documents</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
    body { font-family:Arial; background:#f3f3f3; margin:0; }
    .topbar {
        background:#00428B; padding:12px; color:white;
        display:flex; justify-content:space-between; align-items:center;
    }
    .container { padding:15px; max-width:1100px; margin:auto; }
    table {
        width:100%; border-collapse:collapse; background:white;
        border-radius:10px; overflow:hidden; margin-top:15px;
    }
    th, td {
        padding:10px; font-size:14px; border-bottom:1px solid #ddd;
        text-align:left;
    }
    th {
        background:#00428B; color:white; cursor:pointer;
    }
    tr:hover { background:#f1f7ff; }
    a { color:#00428B; text-decoration:none; font-weight:bold; }
</style>
</head>
<body>

<div class="topbar">
    <div><b>DocNLink — Tableau des documents</b></div>
    <a href="admin-panel.php" style="color:white; text-decoration:none;">⬅ Retour Admin</a>
</div>

<div class="container">

<table class="sortable">
<tr>
    <th>Parc / ID</th>
    <th>Nom engin</th>
    <th>Assurance</th>
    <th>VGP</th>
    <th>🔧</th>
</tr>

<?php foreach ($engins as $e): ?>
<tr>
    <td><?php echo htmlspecialchars($e["immat"]); ?></td>
    <td><?php echo htmlspecialchars($e["nom"]); ?></td>
    <td><?php echo badge($e["assurance"]); ?></td>
    <td><?php echo badge($e["vgp"]); ?></td>
    <td>
        <a href="admin-documents.php?client=<?php echo $client; ?>&id=<?php echo $e["id"]; ?>">
            Gérer ➜
        </a>
    </td>
</tr>
<?php endforeach; ?>

</table>

</div>

<script>
// TRI DU TABLEAU
document.querySelectorAll("th").forEach((header, index) => {
    header.addEventListener("click", () => {
        const table = header.closest("table");
        const rows = Array.from(table.querySelectorAll("tr:nth-child(n+2)"));
        const asc = header.classList.toggle("asc");

        const parseDate = d => {
            if (!d) return 0;
            d = d.replace(/[^0-9\/\-]/g, "");
            if (d.includes("/")) {
                const [dd, mm, yy] = d.split("/");
                return new Date("20" + yy, mm - 1, dd).getTime();
            }
            return new Date(d).getTime() || 0;
        };

        rows.sort((a, b) => {
            const cellA = a.children[index].innerText.trim();
            const cellB = b.children[index].innerText.trim();

            const dateRegex = /\d{4}-\d{2}-\d{2}|\d{2}\/\d{2}\/\d{2}/;
            if (cellA.match(dateRegex) || cellB.match(dateRegex)) {
                return asc ? parseDate(cellA) - parseDate(cellB)
                           : parseDate(cellB) - parseDate(cellA);
            }

            if (!isNaN(cellA) && !isNaN(cellB)) {
                return asc ? cellA - cellB : cellB - cellA;
            }

            return asc ? cellA.localeCompare(cellB)
                       : cellB.localeCompare(cellA);
        });

        rows.forEach(r => table.appendChild(r));
    });
});
</script>

</body>
</html>
