<?php
session_start();

if (!isset($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header('Location: admin-login.php');
    exit;
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

// ========================
// Paramètres de base
// ========================
$client = $_GET['client'] ?? '';
$id     = $_GET['id'] ?? '';

if (!$client || !$id) {
    die("Erreur : client ou ID manquant.");
}

$basePath    = "/var/www/docnlink/data";
$docsDir     = "$basePath/documents/$client/$id";
$jsonPath    = "$basePath/clients/$client/engins/$id.json";
$photoFolder = "$basePath/photos/$client/$id";
$photoURL    = "https://docnlink.fr/data/photos/$client/$id";

if (!file_exists($jsonPath)) {
    die("Erreur : fiche engin introuvable.");
}

if (!is_dir($docsDir))      mkdir($docsDir, 0775, true);
if (!is_dir($photoFolder)) mkdir($photoFolder, 0775, true);

$data = json_decode(file_get_contents($jsonPath), true);
if (!$data) {
    die("Erreur lecture JSON.");
}

// ========================
// TRAITEMENT PHOTO
// ========================
if (isset($_POST['update_photo']) && !empty($_FILES['new_photo']['tmp_name'])) {

    // Effacer les anciennes photos
    foreach (glob($photoFolder."/*.{jpg,jpeg,png}", GLOB_BRACE) as $old) {
        unlink($old);
    }

    $ext = strtolower(pathinfo($_FILES['new_photo']['name'], PATHINFO_EXTENSION));
    if (!in_array($ext, ['jpg','jpeg','png'])) {
        die("Format photo invalide (jpg/jpeg/png uniquement).");
    }

    $cleanName = preg_replace('/[^a-zA-Z0-9._-]/', '_', $_FILES['new_photo']['name']);
    $dest      = "$photoFolder/$cleanName";

    move_uploaded_file($_FILES['new_photo']['tmp_name'], $dest);

    $data['photo'] = "$photoURL/$cleanName";
    file_put_contents($jsonPath, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    header("Location: admin-documents.php?client=$client&id=$id");
    exit;
}

// ========================
// UPLOAD DOCUMENT
// ========================
if (isset($_POST['upload'])) {

    if (!empty($_FILES['file']['name'])) {

        // Gestion des erreurs d'upload
        switch ($_FILES['file']['error']) {
            case UPLOAD_ERR_INI_SIZE:
            case UPLOAD_ERR_FORM_SIZE:
                die("⚠️ Le fichier est trop volumineux. Limite : 50 Mo.");
            case UPLOAD_ERR_PARTIAL:
                die("⚠️ Upload interrompu. Vérifiez la connexion.");
            case UPLOAD_ERR_NO_FILE:
                die("⚠️ Aucun fichier reçu.");
            case UPLOAD_ERR_OK:
                // ok on continue
                break;
            default:
                die("⚠️ Erreur upload : code ".$_FILES['file']['error']);
        }

        // Nettoyage nom fichier
        $fileName = preg_replace('/[^a-zA-Z0-9._-]/', '_', $_FILES['file']['name']);
        $target   = "$docsDir/$fileName";

        // Vérification extension
        $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        if (!in_array($ext, ["pdf","jpg","jpeg","png"])) {
            die("⚠️ Format non autorisé. Autorisés : pdf, jpg, jpeg, png.");
        }

        // Upload effectif
        if (!move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
            die("⚠️ Erreur : impossible d'enregistrer le fichier sur le serveur.");
        }
    }

    header("Location: admin-documents.php?client=$client&id=$id");
    exit;
}

// ========================
// SUPPRESSION DOCUMENT
// ========================
if (isset($_GET['delete'])) {

    $file = basename($_GET['delete']);
    $path = "$docsDir/$file";

    if (file_exists($path)) unlink($path);

    header("Location: admin-documents.php?client=$client&id=$id");
    exit;
}

// ========================
// RENOMMER DOCUMENT
// ========================
if (isset($_POST['rename_from']) && isset($_POST['rename_to'])) {

    $from = basename($_POST['rename_from']);
    $to   = preg_replace('/[^a-zA-Z0-9._-]/', '_', $_POST['rename_to']);

    $src = "$docsDir/$from";
    $dst = "$docsDir/$to";

    if ($from && $to && file_exists($src)) {
        rename($src, $dst);
    }

    header("Location: admin-documents.php?client=$client&id=$id");
    exit;
}

// ========================
// DATES VALIDITÉ
// ========================
if (isset($_POST['save_dates'])) {

    $data['validite']['assurance'] = $_POST['date_assurance'] ?? "";
    $data['validite']['vgp']       = $_POST['date_vgp'] ?? "";

    file_put_contents($jsonPath, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    header("Location: admin-documents.php?client=$client&id=$id");
    exit;
}

// ========================
// LISTAGE
// ========================
$files = [];
foreach (glob("$docsDir/*") as $f) {
    if (is_file($f)) $files[] = basename($f);
}

$assuranceDate = $data['validite']['assurance'] ?? "";
$vgpDate       = $data['validite']['vgp'] ?? "";

$photoFile = "";
foreach (glob($photoFolder."/*.{jpg,jpeg,png}", GLOB_BRACE) as $pf) {
    $photoFile = basename($pf);
    break;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Gestion - <?php echo htmlspecialchars($id); ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
    :root { --primary:#00428B; --danger:#d9534f; --bg:#f3f3f3; }
    body { margin:0; background:var(--bg); font-family:Arial, sans-serif; }
    .topbar {
        background:var(--primary); color:white;
        padding:12px; display:flex; justify-content:space-between; align-items:center;
    }
    .container { max-width:900px; margin:auto; padding:10px; }
    .card {
        background:white; padding:15px; border-radius:10px;
        margin-bottom:12px; box-shadow:0 2px 6px rgba(0,0,0,0.15);
    }
    .btn {
        padding:10px;
        border-radius:6px;
        display:block;
        text-align:center;
        background:var(--primary);
        color:white;
        text-decoration:none;
        margin-top:8px;
        border:none;
        cursor:pointer;
    }
    .btn-danger { background:var(--danger); }
    .btn-outline {
        background:white;
        border:1px solid var(--primary);
        color:var(--primary);
        cursor:pointer;
        padding:8px 10px;
        border-radius:6px;
        margin-top:6px;
    }
    .file-block { margin-bottom:12px; }

    /* Drag & Drop */
    #dropZone {
        border:2px dashed #999;
        padding:25px;
        text-align:center;
        border-radius:10px;
        color:#444;
        margin-bottom:8px;
    }
    #dropZone.dragover {
        border-color:#00428B;
        background:#e7f0ff;
    }
    .file-status {
        font-size:13px;
        color:#555;
        margin-bottom:6px;
    }
</style>

<script>
// DRAG & DROP POUR LES DOCUMENTS
document.addEventListener("DOMContentLoaded", () => {
    const drop       = document.getElementById("dropZone");
    const fileInput  = document.getElementById("fileInput");
    const uploadBtn  = document.getElementById("uploadButton");
    const statusSpan = document.getElementById("fileStatus");

    if (!drop || !fileInput || !uploadBtn) return;

    function setStatusFromFiles(files) {
        if (!statusSpan) return;
        if (!files || files.length === 0) {
            statusSpan.textContent = "Aucun fichier sélectionné";
            uploadBtn.style.background = "var(--primary)";
            uploadBtn.textContent = "Enregistrer";
            return;
        }

        statusSpan.textContent = files.length === 1
            ? "Prêt : " + files[0].name
            : "Prêt : " + files.length + " fichiers";

        uploadBtn.style.background = "#008000";
        uploadBtn.textContent = "✔ Prêt - Enregistrer";
    }

    drop.addEventListener("dragover", (e) => {
        e.preventDefault();
        drop.classList.add("dragover");
    });

    drop.addEventListener("dragleave", () => {
        drop.classList.remove("dragover");
    });

    drop.addEventListener("drop", (e) => {
        e.preventDefault();
        drop.classList.remove("dragover");
        if (e.dataTransfer.files && e.dataTransfer.files.length > 0) {
            fileInput.files = e.dataTransfer.files;
            setStatusFromFiles(e.dataTransfer.files);
        }
    });

    fileInput.addEventListener("change", () => {
        setStatusFromFiles(fileInput.files);
    });
});
</script>
</head>

<body>

<div class="topbar">
    <span>📁 DocNLink — <?php echo htmlspecialchars($id); ?></span>
    <div>
        <a href="admin-panel.php" style="color:white; text-decoration:none; margin-right:10px;">🏁 Admin</a>
        <a href="fiche-engin.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>" style="color:white; text-decoration:none;">↩ Fiche</a>
    </div>
</div>

<div class="container">

    <!-- PHOTO -->
    <div class="card">
        <h2>🖼️ Photo de l'engin</h2>

        <?php if ($photoFile): ?>
            <img src="<?php echo $photoURL . '/' . $photoFile . '?v=' . time(); ?>"
                 style="width:100%; border-radius:8px; margin-bottom:10px;">
        <?php else: ?>
            <p>Aucune photo trouvée.</p>
        <?php endif; ?>

        <form method="POST" enctype="multipart/form-data">
            <input type="file" name="new_photo" accept="image/*" required>
            <button class="btn" name="update_photo">📸 Enregistrer la photo</button>
        </form>
    </div>

    <!-- DOCUMENTS -->
    <div class="card">
        <h2>📄 Documents</h2>

        <?php foreach ($files as $fname): ?>
            <div class="file-block">
                <b><?php echo htmlspecialchars($fname); ?></b>

                <form method="POST">
                    <input type="hidden" name="rename_from" value="<?php echo htmlspecialchars($fname); ?>">
                    <input type="text" name="rename_to" value="<?php echo htmlspecialchars($fname); ?>">
                    <button class="btn-outline" type="submit">Renommer</button>
                </form>

                <a class="btn btn-danger"
                   href="admin-documents.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>&delete=<?php echo urlencode($fname); ?>">
                    🗑 Supprimer
                </a>
            </div>
        <?php endforeach; ?>

        <?php if (empty($files)): ?>
            <p>Aucun document.</p>
        <?php endif; ?>
    </div>

    <!-- UPLOAD -->
    <div class="card">
        <h2>⬆️ Ajouter un document</h2>

        <div id="dropZone">Déposer un fichier ici ou cliquer pour choisir</div>
        <div class="file-status" id="fileStatus">Aucun fichier sélectionné</div>

        <form method="POST" enctype="multipart/form-data">
            <input type="file" name="file" id="fileInput" required>
            <button class="btn" name="upload" id="uploadButton" type="submit">Enregistrer</button>
        </form>
    </div>

    <!-- DATES -->
    <div class="card">
        <h2>📅 Dates de validité</h2>

        <form method="POST">
            <label>Assurance</label>
            <input type="date" name="date_assurance" value="<?php echo htmlspecialchars($assuranceDate); ?>">

            <label>VGP</label>
            <input type="date" name="date_vgp" value="<?php echo htmlspecialchars($vgpDate); ?>">

            <button class="btn" name="save_dates" type="submit">💾 Enregistrer</button>
        </form>
    </div>

</div>

</body>
</html>
