<?php
session_start();

if (!isset($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header('Location: admin-login.php');
    exit;
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

$client = $_GET['client'] ?? 'ECF_VIGIER';

$dataRoot = "/var/www/docnlink/data";
$enginsDir = "$dataRoot/clients/$client/engins";

if (!is_dir($enginsDir)) {
    die("Dossier engins introuvable : $enginsDir");
}

// ================================
// Récupération de TOUS les entretiens
// ================================
$entretiensGlobal = [];
$today = strtotime("today");

foreach (glob("$enginsDir/*.json") as $file) {
    $id = basename($file, ".json");
    $data = json_decode(file_get_contents($file), true);

    if (!is_array($data) || !isset($data['entretiens'])) continue;

    $marque = $data['nom'] ?? "";
    $type   = $data['type'] ?? "";
    $immat  = $data['immat'] ?? $id;

    foreach ($data['entretiens'] as $e) {

        $date            = $e['date'] ?? "";
        $compteur        = $e['compteur'] ?? "";
        $nom             = $e['nom'] ?? "";
        $garage          = $e['garage'] ?? "";
        $typeEntretien   = $e['type'] ?? "";
        $commentaire     = $e['commentaire'] ?? "";

        $pDate           = $e['prochain_entretien_date'] ?? "";
        $pComment        = $e['prochain_entretien_commentaire'] ?? "";
        $pCompteur       = $e['prochain_entretien_compteur'] ?? "";

        // statut du prochain entretien
        $alert = "OK";
        if ($pDate) {
            $ts = strtotime($pDate);
            if ($ts < $today)       $alert = "EXP";
            elseif ($ts < $today + 15 * 24 * 3600) $alert = "SOON";
        }

        $entretiensGlobal[] = [
            "enginID"   => $id,
            "immat"     => $immat,
            "marque"    => $marque,
            "type"      => $type,
            "date"      => $date,
            "compteur"  => $compteur,
            "nom"       => $nom,
            "garage"    => $garage,
            "typeEnt"   => $typeEntretien,
            "comment"   => $commentaire,
            "pDate"     => $pDate,
            "pComment"  => $pComment,
            "pCompteur" => $pCompteur,
            "alert"     => $alert
        ];
    }
}

// tri du plus récent au plus ancien
usort($entretiensGlobal, function($a, $b){
    return strcmp($b['date'], $a['date']);
});

function formatFR($d){
    if (!$d) return "";
    $ts = strtotime($d);
    if (!$ts) return $d;
    return date("d/m/Y", $ts);
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Tableau global des entretiens</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
:root {
    --primary:#00428B;
    --danger:#C00000;
    --soon:#ff8800;
    --ok:#008000;
    --bg:#f3f3f3;
}

body {
    margin:0;
    font-family:Arial, sans-serif;
    background:var(--bg);
}

.topbar {
    background:var(--primary);
    color:white;
    padding:12px;
    display:flex;
    justify-content:space-between;
}

.topbar a { color:white; text-decoration:none; }

.container {
    max-width:1100px;
    margin:0 auto;
    padding:15px;
}

.card {
    background:white;
    padding:15px;
    border-radius:10px;
    box-shadow:0 2px 6px rgba(0,0,0,0.15);
    margin-bottom:15px;
}

table {
    width:100%;
    border-collapse:collapse;
    font-size:13px;
}

th, td{
    padding:8px;
    border-bottom:1px solid #ddd;
}

th {
    background:#f0f0f0;
}

.alert-exp {
    color:white;
    background:var(--danger);
    padding:3px 6px;
    border-radius:4px;
    font-size:11px;
}

.alert-soon {
    background:var(--soon);
    color:white;
    padding:3px 6px;
    border-radius:4px;
    font-size:11px;
}

.alert-ok {
    background:var(--ok);
    color:white;
    padding:3px 6px;
    border-radius:4px;
    font-size:11px;
}

@media (max-width:800px){
    table, thead, tbody, th, td, tr { display:block; }
    thead { display:none; }
    tr { margin-bottom:15px; padding:10px; border:1px solid #ccc; border-radius:10px; }
    td { border:none; padding:5px 0; }
    td::before {
        content:attr(data-label) " : ";
        font-weight:bold;
    }
}
</style>

<script>
// filtre
document.addEventListener("DOMContentLoaded", () => {
    const input = document.getElementById("searchInput");
    const rows = document.querySelectorAll("#table tbody tr");

    input.addEventListener("input", () => {
        const q = input.value.toLowerCase().trim();
        rows.forEach(r => {
            r.style.display = r.innerText.toLowerCase().includes(q) ? "" : "none";
        });
    });
});
</script>

</head>
<body>

<div class="topbar">
    <div><strong>🛠️ Tableau global des entretiens</strong></div>
    <div>
        <a href="admin-panel.php">🏁 Admin</a>
    </div>
</div>

<div class="container">

    <div class="card">
        <input id="searchInput" placeholder="Rechercher…" style="width:100%;padding:10px;border-radius:6px;border:1px solid #ccc;">
    </div>

    <div class="card">
        <table id="table">
            <thead>
                <tr>
                    <th>Engin</th>
                    <th>Date</th>
                    <th>Nom</th>
                    <th>Garage</th>
                    <th>Compteur</th>
                    <th>Type</th>
                    <th>Commentaire</th>
                    <th>Prochain entretien</th>
                    <th>Statut</th>
                </tr>
            </thead>
            <tbody>

            <?php foreach ($entretiensGlobal as $e): ?>
                <tr>
                    <td data-label="Engin">
                        <b><?php echo htmlspecialchars($e['immat']); ?></b><br>
                        <small><?php echo htmlspecialchars($e['marque']); ?></small>
                    </td>

                    <td data-label="Date"><?php echo formatFR($e['date']); ?></td>

                    <td data-label="Nom"><?php echo htmlspecialchars($e['nom']); ?></td>
                    <td data-label="Garage"><?php echo htmlspecialchars($e['garage']); ?></td>

                    <td data-label="Compteur"><?php echo htmlspecialchars($e['compteur']); ?></td>

                    <td data-label="Type"><?php echo htmlspecialchars($e['typeEnt']); ?></td>

                    <td data-label="Commentaire">
                        <?php echo nl2br(htmlspecialchars($e['comment'])); ?>
                    </td>

                    <td data-label="Prochain entretien">
                        <?php if ($e['pDate']): ?>
                            <b><?php echo formatFR($e['pDate']); ?></b><br>
                        <?php endif; ?>

                        <?php if ($e['pCompteur']): ?>
                            <small>Compteur : <?php echo htmlspecialchars($e['pCompteur']); ?></small><br>
                        <?php endif; ?>

                        <?php if ($e['pComment']): ?>
                            <small><?php echo nl2br(htmlspecialchars($e['pComment'])); ?></small>
                        <?php endif; ?>
                    </td>

                    <td data-label="Statut">
                        <?php if ($e['alert'] === "EXP"): ?>
                            <span class="alert-exp">EXPIRÉ</span>

                        <?php elseif ($e['alert'] === "SOON"): ?>
                            <span class="alert-soon">Bientôt</span>

                        <?php else: ?>
                            <span class="alert-ok">OK</span>
                        <?php endif; ?>
                    </td>

                </tr>
            <?php endforeach; ?>

            </tbody>
        </table>
    </div>

</div>

</body>
</html>
