<?php
session_start();

if (!isset($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header('Location: admin-login.php');
    exit;
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

$client = $_GET['client'] ?? '';
$id     = $_GET['id']     ?? '';

if (!$client || !$id) {
    die("Client ou ID d'engin manquant.");
}

$basePath = "/var/www/docnlink/data";
$jsonPath = "$basePath/clients/$client/engins/$id.json";

if (!file_exists($jsonPath)) {
    die("Fiche engin introuvable : $jsonPath");
}

$data = json_decode(file_get_contents($jsonPath), true);
if (!is_array($data)) {
    die("Erreur JSON engin.");
}

// ========================
// Normalisation des entretiens (compatibilité ancienne structure)
// + ajout d'un UUID si manquant
// ========================
$rawEntretiens = $data['entretiens'] ?? [];
$entretiens    = [];
$changed       = false;

if (is_array($rawEntretiens)) {
    foreach ($rawEntretiens as $e) {
        $ent = [];

        // UUID
        if (!empty($e['id'])) {
            $ent['id'] = $e['id'];
        } else {
            $ent['id'] = uniqid('ent_', true);
            $changed   = true;
        }

        $ent['date'] = $e['date'] ?? '';

        $ent['nom']  = $e['nom'] ?? '';

        $ent['garage_ou_chauffeur'] =
            $e['garage_ou_chauffeur'] ??
            ($e['garage'] ?? '');

        $ent['compteur'] = $e['compteur'] ?? '';

        $ent['type_entretien'] =
            $e['type_entretien'] ??
            ($e['type'] ?? '');

        $ent['commentaire'] = $e['commentaire'] ?? '';

        $ent['prochain_entretien'] =
            $e['prochain_entretien'] ??
            ($e['prochain_entretien_date'] ?? '');

        $ent['commentaire_prochain'] =
            $e['commentaire_prochain'] ??
            ($e['prochain_entretien_commentaire'] ?? '');

        $ent['compteur_prochain'] =
            $e['compteur_prochain'] ??
            ($e['prochain_entretien_compteur'] ?? '');

        $entretiens[] = $ent;
    }
}

// Si normalisation => on réécrit le JSON
if ($changed) {
    $data['entretiens'] = $entretiens;
    file_put_contents($jsonPath, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// ========================
// TRAITEMENT : suppression par UUID
// ========================
if (isset($_GET['delete_id'])) {
    $deleteId = $_GET['delete_id'];

    $newList = [];
    foreach ($entretiens as $e) {
        if (($e['id'] ?? '') !== $deleteId) {
            $newList[] = $e;
        }
    }

    $data['entretiens'] = $newList;
    file_put_contents($jsonPath, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    header("Location: admin-entretien.php?client=" . urlencode($client) . "&id=" . urlencode($id));
    exit;
}

// ========================
// TRAITEMENT : ajout entretien admin
// ========================
$msgError   = "";
$msgSuccess = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_entretien_admin'])) {

    $ent = [
        'id'                   => uniqid('ent_', true),
        'date'                 => trim($_POST['date'] ?? ''),
        'nom'                  => trim($_POST['nom'] ?? ''),
        'garage_ou_chauffeur'  => trim($_POST['garage_ou_chauffeur'] ?? ''),
        'compteur'             => trim($_POST['compteur'] ?? ''),
        'type_entretien'       => trim($_POST['type_entretien'] ?? ''),
        'commentaire'          => trim($_POST['commentaire'] ?? ''),
        'prochain_entretien'   => trim($_POST['prochain_entretien'] ?? ''),
        'commentaire_prochain' => trim($_POST['commentaire_prochain'] ?? ''),
        'compteur_prochain'    => trim($_POST['compteur_prochain'] ?? '')
    ];

    if ($ent['date'] === '' || $ent['type_entretien'] === '') {
        $msgError = "La date et le type d'entretien sont obligatoires.";
    } else {
        $entretiens[] = $ent;
        $data['entretiens'] = $entretiens;

        if (file_put_contents($jsonPath, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) === false) {
            $msgError = "Erreur lors de l'enregistrement.";
        } else {
            header("Location: admin-entretien.php?client=" . urlencode($client) . "&id=" . urlencode($id));
            exit;
        }
    }
}

// Re-tri du plus récent au plus ancien
if (is_array($entretiens)) {
    usort($entretiens, function($a, $b) {
        $ta = !empty($a['date']) ? strtotime($a['date']) : 0;
        $tb = !empty($b['date']) ? strtotime($b['date']) : 0;
        return $tb <=> $ta;
    });
}

// Infos engin
$nomEngin    = $data['nom']   ?? $id;
$immat       = $data['immat'] ?? $id;
$typeEngin   = $data['type']  ?? '';
$numeroSerie = $data['numero_serie'] ?? '';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Admin – Entretiens <?php echo htmlspecialchars($immat); ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
    :root { --primary:#00428B; --danger:#d9534f; --bg:#f3f3f3; }
    body {
        margin:0;
        font-family:Arial, sans-serif;
        background:var(--bg);
    }
    .topbar {
        background:var(--primary); color:white;
        padding:10px 15px;
        display:flex; justify-content:space-between; align-items:center;
    }
    .topbar a {
        color:white; text-decoration:none; margin-left:10px; font-size:14px;
    }
    .container {
        max-width:1000px; margin:15px auto; padding:0 10px;
    }
    .card {
        background:white; border-radius:10px;
        padding:15px; margin-bottom:15px;
        box-shadow:0 2px 6px rgba(0,0,0,0.15);
    }
    h1 { margin:0 0 8px 0; font-size:20px; }
    h2 { margin:0 0 10px 0; font-size:18px; border-bottom:1px solid #eee; padding-bottom:4px; }
    table {
        width:100%; border-collapse:collapse; font-size:13px;
    }
    th, td {
        border-bottom:1px solid #eee; padding:6px 5px; vertical-align:top;
    }
    th { background:#f7f7f7; }
    .btn {
        display:inline-block; padding:8px 10px;
        border-radius:6px; border:none; cursor:pointer;
        text-decoration:none; font-size:13px;
    }
    .btn-primary { background:var(--primary); color:white; }
    .btn-danger  { background:var(--danger);  color:white; }
    .btn-grey    { background:#555;          color:white; }
    input[type="text"], input[type="date"], textarea {
        width:100%; padding:6px; border-radius:5px; border:1px solid #ccc;
        font-size:13px; box-sizing:border-box;
    }
    textarea { resize:vertical; }
    .msg-error { color:#d9534f; font-weight:bold; margin-bottom:8px; }
    .msg-success { color:#5cb85c; font-weight:bold; margin-bottom:8px; }
</style>
</head>
<body>

<div class="topbar">
    <div>
        🔧 Entretiens – <?php echo htmlspecialchars($immat); ?>
    </div>
    <div>
        <a href="admin-panel.php">🏁 Admin</a>
        <a href="fiche-engin.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>">📄 Fiche</a>
        <a href="admin-documents.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>">📁 Docs</a>
    </div>
</div>

<div class="container">

    <div class="card">
        <h1><?php echo htmlspecialchars($nomEngin); ?></h1>
        <p>
            <b>Parc / Immat :</b> <?php echo htmlspecialchars($immat); ?><br>
            <b>Type :</b> <?php echo htmlspecialchars($typeEngin); ?><br>
            <b>N° série :</b> <?php echo htmlspecialchars($numeroSerie); ?>
        </p>
    </div>

    <div class="card">
        <h2>Historique des entretiens</h2>

        <?php if (!empty($msgError)): ?>
            <div class="msg-error"><?php echo htmlspecialchars($msgError); ?></div>
        <?php elseif (!empty($msgSuccess)): ?>
            <div class="msg-success"><?php echo htmlspecialchars($msgSuccess); ?></div>
        <?php endif; ?>

        <?php if (empty($entretiens)): ?>
            <p style="color:#777;">Aucun entretien enregistré.</p>
        <?php else: ?>
            <div style="max-height:320px; overflow:auto;">
                <table>
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Nom</th>
                            <th>Garage / Chauffeur</th>
                            <th>Compteur (h / km)</th>
                            <th>Type d'entretien</th>
                            <th>Commentaire</th>
                            <th>Prochain entretien</th>
                            <th>Commentaire prochain</th>
                            <th>Compteur prochain</th>
                            <th>Suppression</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($entretiens as $e): ?>
                        <tr>
                            <td>
                                <?php
                                if (!empty($e['date'])) {
                                    echo htmlspecialchars(date('d/m/y', strtotime($e['date'])));
                                } else {
                                    echo '—';
                                }
                                ?>
                            </td>
                            <td><?php echo htmlspecialchars($e['nom'] ?? ''); ?></td>
                            <td><?php echo htmlspecialchars($e['garage_ou_chauffeur'] ?? ''); ?></td>
                            <td><?php echo htmlspecialchars($e['compteur'] ?? ''); ?></td>
                            <td><?php echo htmlspecialchars($e['type_entretien'] ?? ''); ?></td>
                            <td><?php echo nl2br(htmlspecialchars($e['commentaire'] ?? '')); ?></td>
                            <td>
                                <?php
                                if (!empty($e['prochain_entretien'])) {
                                    echo htmlspecialchars(date('d/m/y', strtotime($e['prochain_entretien'])));
                                } else {
                                    echo '—';
                                }
                                ?>
                            </td>
                            <td><?php echo nl2br(htmlspecialchars($e['commentaire_prochain'] ?? '')); ?></td>
                            <td><?php echo htmlspecialchars($e['compteur_prochain'] ?? ''); ?></td>
                            <td>
                                <a class="btn btn-danger"
                                   href="admin-entretien.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>&delete_id=<?php echo urlencode($e['id']); ?>"
                                   onclick="return confirm('Supprimer cet entretien ?');">
                                    🗑
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <div class="card">
        <h2>Ajouter un entretien (admin)</h2>

        <form method="POST">
            <input type="hidden" name="add_entretien_admin" value="1">

            <p>
                <label>Date :</label><br>
                <input type="date" name="date" required>
            </p>
            <p>
                <label>Nom :</label><br>
                <input type="text" name="nom" placeholder="Nom de la personne">
            </p>
            <p>
                <label>Garage ou Chauffeur :</label><br>
                <input type="text" name="garage_ou_chauffeur" placeholder="Garage ou chauffeur">
            </p>
            <p>
                <label>Compteur (heures ou kilomètres) :</label><br>
                <input type="text" name="compteur" placeholder="Ex : 3 250 h ou 125 000 km">
            </p>
            <p>
                <label>Type d'entretien :</label><br>
                <input type="text" name="type_entretien" placeholder="Vidange, révision, freinage..." required>
            </p>
            <p>
                <label>Commentaire :</label><br>
                <textarea name="commentaire" rows="3"></textarea>
            </p>

            <hr>

            <p>
                <label>Prochain entretien (date) :</label><br>
                <input type="date" name="prochain_entretien">
            </p>
            <p>
                <label>Compteur prévu (heures / km) :</label><br>
                <input type="text" name="compteur_prochain">
            </p>
            <p>
                <label>Commentaire prochain entretien :</label><br>
                <textarea name="commentaire_prochain" rows="2"></textarea>
            </p>

            <button type="submit" class="btn btn-primary">💾 Enregistrer</button>
        </form>
    </div>

</div>

</body>
</html>
