<?php
session_start();

if (!isset($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header('Location: admin-login.php');
    exit;
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

// ========================
// Paramètres
// ========================
$client = $_GET['client'] ?? '';
$id     = $_GET['id'] ?? '';

if (!$client || !$id) {
    http_response_code(400);
    die("Client ou ID d'engin manquant.");
}

$basePath = "/var/www/docnlink/data";
$jsonPath = "$basePath/clients/$client/engins/$id.json";

if (!file_exists($jsonPath)) {
    http_response_code(404);
    die("Fiche engin introuvable : $jsonPath");
}

$data = json_decode(file_get_contents($jsonPath), true);
if (!is_array($data)) {
    die("Erreur JSON engin.");
}

// Numéro de parc / immat
$immat   = $data['immat'] ?? $id;
$enginID = $immat ?: $id;

// URL pointée par le QR
$enginUrl = "https://docnlink.fr/fiche-engin.php?client="
    . urlencode($client)
    . "&id=" . urlencode($id);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>QR Engin <?php echo htmlspecialchars($enginID); ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
    /* Page imprimée 50 x 80 mm */
    @page {
        size: 50mm 80mm;
        margin: 0;
    }

    @media print {
        .no-print { display: none !important; }
        body {
            margin: 0;
            padding: 0;
        }
    }

    body {
        margin: 0;
        padding: 10px;
        font-family: Arial, sans-serif;
        background:#f3f3f3;
    }

    .wrapper {
        width: 50mm;
        height: 80mm;
        margin: 0 auto;
        background: #fff;
        border-radius: 6px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.2);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: space-between;
        padding: 6mm 4mm 4mm 4mm;
        box-sizing: border-box;
    }

    .qr-box {
        width: 40mm;
        height: 40mm;
        display:flex;
        align-items:center;
        justify-content:center;
    }

    #qrcode canvas, #qrcode img {
        width: 100% !important;
        height: 100% !important;
    }

    .label {
        font-size: 14px;
        font-weight: bold;
        text-align: center;
        margin-top: 4mm;
    }

    .client {
        font-size: 9px;
        text-align:center;
        margin-bottom: 1mm;
        color:#555;
    }

    .actions {
        margin: 10px auto;
        max-width: 320px;
        text-align:center;
    }
    .btn {
        display:inline-block;
        padding:8px 12px;
        margin:2px;
        border-radius:6px;
        border:none;
        cursor:pointer;
        font-size:14px;
        text-decoration:none;
        color:#fff;
        background:#00428B;
    }
    .btn-secondary {
        background:#777;
    }

    .url-debug.no-print {
        font-size: 11px;
        color:#555;
        text-align:center;
        margin-top:4px;
        word-break:break-all;
    }
</style>
</head>
<body>

<div class="actions no-print">
    <a class="btn" href="admin-documents.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>">⬅ Retour Admin</a>
    <button class="btn-secondary" onclick="window.print()">🖨️ Imprimer</button>
    <a id="downloadPng" class="btn" href="#" download="QR_<?php echo htmlspecialchars($enginID); ?>.png">⬇ Télécharger PNG</a>
</div>

<div class="wrapper">
    <div class="qr-box">
        <div id="qrcode"></div>
    </div>
    <div class="label"><?php echo htmlspecialchars($enginID); ?></div>
    <div class="client"><?php echo htmlspecialchars(str_replace('_',' ', $client)); ?></div>
</div>

<div class="url-debug no-print">
    URL encodée : <?php echo htmlspecialchars($enginUrl); ?>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script>
(function() {
    var qrContainer = document.getElementById("qrcode");
    if (!qrContainer) return;

    // ⚠ Ici on utilise json_encode côté PHP pour être sûr que
    // l'URL complète (avec &id=...) soit bien injectée dans JS.
    var qrText = <?php echo json_encode($enginUrl); ?>;

    var qrcode = new QRCode(qrContainer, {
        text: qrText,
        width: 256,
        height: 256,
        correctLevel: QRCode.CorrectLevel.H
    });

    function updateDownloadLink() {
        var canvas = qrContainer.querySelector("canvas");
        var link   = document.getElementById("downloadPng");
        if (canvas && link) {
            try {
                var dataURL = canvas.toDataURL("image/png");
                link.href = dataURL;
            } catch (e) {
                console.error(e);
            }
        }
    }

    setTimeout(updateDownloadLink, 400);
})();
</script>

</body>
</html>
