<?php
// ===============================================
// ⚠️ Empêcher Google / bots d'indexer la page
// ===============================================
header("X-Robots-Tag: noindex, nofollow", true);

// ===============================================
// 🔐 Sécurité : Vérification ID + TOKEN
// ===============================================
if (!isset($_GET['id']) || !isset($_GET['token'])) {
    http_response_code(403);
    die("Accès refusé.");
}

$id = intval($_GET['id']);
$token = $_GET['token'];

// ===============================================
// 🔌 Connexion MySQL
// ===============================================
$pdo = new PDO("mysql:host=localhost;dbname=docnlink;charset=utf8", "phpmyadmin", "TON_MDP");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// ===============================================
// 🔍 Vérifier que l'engin existe et que le token correspond
// ===============================================
$sql = $pdo->prepare("SELECT * FROM engins WHERE id = ? AND token = ?");
$sql->execute([$id, $token]);
$engin = $sql->fetch(PDO::FETCH_ASSOC);

if (!$engin) {
    http_response_code(404);
    die("Engin introuvable ou accès non autorisé.");
}

// ===============================================
// 📄 Charger les documents liés à cet engin
// ===============================================
$sql = $pdo->prepare("SELECT * FROM documents 
                      WHERE cible = 'engin' AND cible_id = ? 
                      ORDER BY type ASC");
$sql->execute([$id]);
$documents = $sql->fetchAll(PDO::FETCH_ASSOC);

// ===============================================
// 🎨 Fonction couleur expiration
// ===============================================
function statut_document($date)
{
    if ($date == "" || $date == null) return ["-", "gris"];

    $jours = (strtotime($date) - time()) / 86400;

    if ($jours < 0) return [$jours, "rouge"];
    if ($jours < 30) return [$jours, "orange"];
    return [$jours, "vert"];
}

// ===============================================
// 🎨 HTML affichage FICHE ENGIN
// ===============================================
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($engin['nom']) ?> - Fiche Engin</title>

<style>
body { font-family: Arial; background:#f5f5f5; margin:0; padding:20px; }
.container { max-width:800px; margin:auto; background:white; padding:20px; border-radius:10px; box-shadow:0 0 10px rgba(0,0,0,0.1); }
h1 { margin-top:0; }
table { width:100%; border-collapse:collapse; margin-top:20px; }
td,th { padding:10px; border-bottom:1px solid #ddd; }
.rouge { background:#ffb3b3; }
.orange { background:#ffe0b3; }
.vert { background:#c2ffb3; }
.gris { background:#eee; }
.doc-btn { text-decoration:none; padding:6px 10px; background:#007bff; color:white; border-radius:5px; }
</style>

</head>
<body>

<div class="container">

    <h1>🚜 <?= htmlspecialchars($engin['nom']) ?></h1>

    <p><strong>Marque :</strong> <?= htmlspecialchars($engin['marque']) ?></p>
    <p><strong>Modèle :</strong> <?= htmlspecialchars($engin['modele']) ?></p>
    <p><strong>N° Série :</strong> <?= htmlspecialchars($engin['numero_serie']) ?></p>

    <?php if ($engin['photo']) : ?>
        <p><img src="/uploads/<?= $engin['photo'] ?>" width="300"></p>
    <?php endif; ?>

    <h2>📄 Documents</h2>

    <table>
        <tr>
            <th>Type</th>
            <th>Expiration</th>
            <th>Jours restants</th>
            <th>Fichier</th>
        </tr>

        <?php foreach ($documents as $doc):
            list($jours, $couleur) = statut_document($doc['date_expiration']);
        ?>
        <tr class="<?= $couleur ?>">
            <td><?= htmlspecialchars($doc['type']) ?></td>
            <td><?= $doc['date_expiration'] ?: "-" ?></td>
            <td><?= is_numeric($jours) ? floor($jours)." j" : "-" ?></td>
            <td>
                <?php if ($doc['fichier']): ?>
                    <a class="doc-btn" href="/uploads/<?= $doc['fichier'] ?>" target="_blank">Ouvrir</a>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; ?>

    </table>

</div>

</body>
</html>
