<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

// ========================
// Chargement & sécurité
// ========================
$client = isset($_GET['client']) ? $_GET['client'] : 'ECF_VIGIER';
$id     = isset($_GET['id']) ? $_GET['id'] : '';

if ($id === '') {
    http_response_code(400);
    die("ID d'engin manquant.");
}

$basePath   = "/var/www/docnlink/data";
$jsonPath   = "$basePath/clients/$client/engins/$id.json";
$docsDir    = "$basePath/documents/$client/$id";
$docsUrlDir = "https://docnlink.fr/data/documents/$client/$id";

if (!file_exists($jsonPath)) {
    http_response_code(404);
    die("Fiche engin introuvable : $jsonPath");
}

$data = json_decode(file_get_contents($jsonPath), true);
if (!is_array($data)) {
    die("Erreur JSON engin.");
}

// ========================
// Fonctions utilitaires
// ========================
function formatFR($d) {
    if (!$d) return "";
    $ts = strtotime($d);
    if (!$ts) return $d;
    return date("d/m/Y", $ts); // JJ/MM/AAAA
}

function badgeDate($d) {
    if (!$d) return "";
    $ts = strtotime($d);
    if (!$ts) return "";
    $today = strtotime(date("Y-m-d"));
    if ($ts < $today) {
        return " <span style='color:red;font-size:12px;font-weight:bold;'> (EXPIRÉ)</span>";
    }
    return " <span style='color:green;font-size:12px;'> (valide)</span>";
}

// Alerte entretien (15 jours)
function entretienStatusBadge($date) {
    if (!$date) return "";
    $ts = strtotime($date);
    if (!$ts) return "";

    $today  = strtotime(date("Y-m-d"));
    $soonTs = $today + 15 * 24 * 3600;

    if ($ts < $today) {
        return " <span style='background:#c00000;color:#fff;padding:2px 6px;border-radius:4px;font-size:11px;'>ENTRET. EN RETARD</span>";
    } elseif ($ts <= $soonTs) {
        return " <span style='background:#ff8800;color:#fff;padding:2px 6px;border-radius:4px;font-size:11px;'>ENTRET. BIENTÔT</span>";
    } else {
        return " <span style='background:#008000;color:#fff;padding:2px 6px;border-radius:4px;font-size:11px;'>ENTRET. OK</span>";
    }
}

// ========================
// Récupération des données
// ========================
$logo        = $data['logo'] ?? "";
$nomEngin    = $data['nom'] ?? $id;
$typeEngin   = $data['type'] ?? "";
$numeroSerie = $data['numero_serie'] ?? "";
$immat       = $data['immat'] ?? $id;
$annee       = $data['annee'] ?? "";
$poids       = $data['poids'] ?? "";

$photoUrl = (!empty($data['photo']))
    ? $data['photo']
    : "https://via.placeholder.com/800x400?text=Photo+non+disponible";

// Dates documents
$vgp       = $data['validite']['vgp'] ?? "";
$assurance = $data['validite']['assurance'] ?? "";

// ========================
// Documents dynamiques
// ========================
$docs = [];
if (is_dir($docsDir)) {
    foreach (glob($docsDir . "/*") as $file) {
        if (is_file($file)) {
            $base     = basename($file);
            $nameOnly = pathinfo($base, PATHINFO_FILENAME);
            $label    = str_replace(['_', '-'], ' ', $nameOnly);
            $label    = mb_convert_case($label, MB_CASE_TITLE);

            $docs[] = [
                "label" => $label,
                "url"   => $docsUrlDir . "/" . rawurlencode($base)
            ];
        }
    }
}

// ========================
// Entretiens : prochain entretien (si existant)
// ========================
$nextEntretien = null;
if (!empty($data['entretiens']) && is_array($data['entretiens'])) {
    $today = strtotime(date("Y-m-d"));

    foreach ($data['entretiens'] as $e) {
        $pd = $e['prochain_entretien_date'] ?? "";
        if (!$pd) continue;

        $ts = strtotime($pd);
        if (!$ts) continue;

        // On prend le plus proche (même s'il est déjà en retard)
        if ($nextEntretien === null || $ts < strtotime($nextEntretien['prochain_entretien_date'])) {
            $nextEntretien = $e;
        }
    }
}

// ========================
// Actions rapides
// ========================
$enginID = $immat ?: $id;

// Mail panne
$mailTo      = "p.aubert@ecf-vigier.com";
$mailSubject = "Déclaration de panne – Engin $enginID";
$mailBody    = "Déclaration de panne\nEngin : $enginID\nCompteur d'heure :\nDate :\n\nMerci d’indiquer la panne et ajouter une photo si possible.";
$mailUrl     = "mailto:$mailTo?subject=" . rawurlencode($mailSubject) . "&body=" . rawurlencode($mailBody);

// WhatsApp panne
$waNumber = "33679505890";
$waMsg    = "Déclaration de panne\nEngin: $enginID\nCompteur d'heure:\nDate:\nMerci d’indiquer la panne et ajouter une photo si possible.";
$waUrl    = "https://wa.me/$waNumber?text=" . rawurlencode($waMsg);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Fiche Engin - <?php echo htmlspecialchars($nomEngin); ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
    body { margin:0; padding:0; background:#f3f3f3; font-family:Arial, sans-serif; }
    .header {
        background:#00428B; color:white;
        padding:10px 15px;
        display:flex; justify-content:space-between; align-items:center;
    }
    .header img { max-height:50px; }
    .container { padding:10px; max-width:900px; margin:auto; }
    .card {
        background:white; border-radius:8px;
        box-shadow:0 2px 6px rgba(0,0,0,0.15);
        padding:15px; margin-bottom:15px;
    }
    h1 { margin:0; font-size:22px; }
    h2 {
        font-size:18px; border-bottom:1px solid #eee;
        margin-bottom:10px; padding-bottom:5px;
    }
    .infos-grid {
        display:grid; grid-template-columns:repeat(2,1fr);
        gap:8px; font-size:14px;
    }
    .label { font-weight:bold; }
    .photo img { width:100%; border-radius:8px; }
    ul { list-style:none; padding:0; margin:0; }
    .btn {
        display:block; background:#00428B; color:white;
        padding:10px; margin-bottom:8px;
        border-radius:6px; text-decoration:none; font-size:15px;
        text-align:center;
    }
    .btn-whatsapp { background:#25D366; }
    .btn-danger   { background:#d9534f; }
    .small { font-size:12px; color:#555; }
</style>
</head>

<body>

<!-- EN-TÊTE -->
<div class="header">
    <div>
        <?php if ($logo): ?>
            <img src="<?php echo htmlspecialchars($logo); ?>">
        <?php endif; ?>
    </div>
    <div><?php echo htmlspecialchars(str_replace('_',' ', $client)); ?></div>
</div>

<div class="container">

    <!-- INFOS -->
    <div class="card">
        <h1><?php echo htmlspecialchars($nomEngin); ?></h1>
        <div class="infos-grid">
            <div><span class="label">Type :</span> <?php echo htmlspecialchars($typeEngin); ?></div>
            <div><span class="label">N° Série :</span> <?php echo htmlspecialchars($numeroSerie); ?></div>
            <div><span class="label">Parc/Immat :</span> <?php echo htmlspecialchars($immat); ?></div>
            <div><span class="label">Année :</span> <?php echo htmlspecialchars($annee); ?></div>
            <div><span class="label">Poids :</span> <?php echo htmlspecialchars($poids); ?></div>
        </div>
    </div>

    <!-- PHOTO -->
    <div class="card">
        <div class="photo">
            <img src="<?php echo htmlspecialchars($photoUrl); ?>">
        </div>
    </div>

    <!-- VALIDITÉ DOCUMENTS -->
    <div class="card">
        <h2>Dates de validité</h2>
        <p>
            <b>Assurance :</b>
            <?php echo $assurance ? formatFR($assurance) : "—"; ?>
            <?php echo badgeDate($assurance); ?>
        </p>
        <p>
            <b>VGP :</b>
            <?php echo $vgp ? formatFR($vgp) : "—"; ?>
            <?php echo badgeDate($vgp); ?>
        </p>
    </div>

    <!-- DOCUMENTS DYNAMIQUES -->
    <div class="card">
        <h2>Documents dynamiques</h2>
        <?php if (empty($docs)): ?>
            <p style="color:#777;">Aucun document trouvé dans le dossier.</p>
        <?php else: ?>
            <ul>
                <?php foreach ($docs as $d): ?>
                    <li>
                        <a class="btn" href="<?php echo $d['url']; ?>" target="_blank">
                            📄 <?php echo htmlspecialchars($d['label']); ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </div>

    <!-- PROCHAIN ENTRETIEN (RÉSUMÉ + BOUTON PUBLIC) -->
    <?php if ($nextEntretien): ?>
        <?php
            $pd  = $nextEntretien['prochain_entretien_date'] ?? "";
            $pc  = $nextEntretien['prochain_entretien_commentaire'] ?? "";
            $pco = $nextEntretien['prochain_entretien_compteur'] ?? "";
        ?>
        <div class="card">
            <h2>Prochain entretien (résumé)</h2>
            <?php if ($pd): ?>
                <p>
                    <b>Date :</b>
                    <?php echo formatFR($pd); ?>
                    <?php echo entretienStatusBadge($pd); ?>
                </p>
            <?php endif; ?>

            <?php if ($pco): ?>
                <p><b>Compteur prévu :</b> <?php echo htmlspecialchars($pco); ?></p>
            <?php endif; ?>

            <?php if ($pc): ?>
                <p><b>Commentaire :</b><br>
                    <span class="small"><?php echo nl2br(htmlspecialchars($pc)); ?></span>
                </p>
            <?php endif; ?>

            <!-- BOUTON PUBLIC : HISTORIQUE + AJOUT -->
            <a class="btn"
               href="fiche-entretien.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>">
               🛠 Historique & ajout d’entretiens
            </a>
        </div>
    <?php else: ?>
        <!-- Même sans prochain entretien, on peut proposer d'accéder directement à l'historique -->
        <div class="card">
            <h2>Entretiens</h2>
            <p class="small" style="color:#666;">Aucun prochain entretien renseigné pour le moment.</p>
            <a class="btn"
               href="fiche-entretien.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>">
               🛠 Historique & ajout d’entretiens
            </a>
        </div>
    <?php endif; ?>

    <!-- ACTIONS RAPIDES -->
    <div class="card">
        <h2>Actions rapides</h2>
        <ul>
            <li>
                <a class="btn"
                   href="admin-documents.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>">
                    ⚙️ Gérer les documents (admin)
                </a>
            </li>
            <li>
                <a class="btn"
                   href="admin-entretien.php?client=<?php echo urlencode($client); ?>&id=<?php echo urlencode($id); ?>">
                    🛠 Entretiens / Historique (admin)
                </a>
            </li>

            <li><a class="btn" href="tel:+33679505890">📞 Appeler Maintenance</a></li>
            <li><a class="btn btn-danger" href="<?php echo $mailUrl; ?>">🚨 Déclarer une panne (Mail)</a></li>
            <li><a class="btn btn-whatsapp" href="<?php echo $waUrl; ?>" target="_blank">🟢 Déclarer une panne (WhatsApp)</a></li>
        </ul>
    </div>

</div>

</body>
</html>
